`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date: 12/12/2023 12:49:14 AM
// Design Name: 
// Module Name: alu
// Project Name: 
// Target Devices: 
// Tool Versions: 
// Description: 
// 
// Dependencies: 
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
//////////////////////////////////////////////////////////////////////////////////


module alu(
        op1,
        op2,
        opcode,
        result,
        flags
    );
    
    parameter word_width  = 16;
    parameter flag_witdh  = 2;
    
    input      [word_width-1 : 0] op1;
    input      [word_width-1 : 0] op2;
    input      [1 : 0] opcode;
    output reg [word_width-1 : 0] result;
    output     [flag_witdh-1 : 0] flags; // S(sing), Z(zero)
    
    always@(*) begin
        case(opcode)
            0: result = op1;        //bypass
            1: result = op1 + op2;  //add
            2: result = op1 - op2;  //sub
            3: result = 0;          //clear
            default: result = op1;  //default - bypass
        endcase  
    end
    
    assign flags[1] = result[word_width-1];
    assign flags[0] = result === 0;
endmodule
